<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Notify\V1\Service;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class UserOptions {
    /**
     * @param string $segment The segment
     * @return CreateUserOptions Options builder
     */
    public static function create($segment = Values::NONE) {
        return new CreateUserOptions($segment);
    }

    /**
     * @param string $identity The identity
     * @param string $segment The segment
     * @return ReadUserOptions Options builder
     */
    public static function read($identity = Values::NONE, $segment = Values::NONE) {
        return new ReadUserOptions($identity, $segment);
    }
}

class CreateUserOptions extends Options {
    /**
     * @param string $segment The segment
     */
    public function __construct($segment = Values::NONE) {
        $this->options['segment'] = $segment;
    }

    /**
     * The segment
     * 
     * @param string $segment The segment
     * @return $this Fluent Builder
     */
    public function setSegment($segment) {
        $this->options['segment'] = $segment;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Notify.V1.CreateUserOptions ' . implode(' ', $options) . ']';
    }
}

class ReadUserOptions extends Options {
    /**
     * @param string $identity The identity
     * @param string $segment The segment
     */
    public function __construct($identity = Values::NONE, $segment = Values::NONE) {
        $this->options['identity'] = $identity;
        $this->options['segment'] = $segment;
    }

    /**
     * The identity
     * 
     * @param string $identity The identity
     * @return $this Fluent Builder
     */
    public function setIdentity($identity) {
        $this->options['identity'] = $identity;
        return $this;
    }

    /**
     * The segment
     * 
     * @param string $segment The segment
     * @return $this Fluent Builder
     */
    public function setSegment($segment) {
        $this->options['segment'] = $segment;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Notify.V1.ReadUserOptions ' . implode(' ', $options) . ']';
    }
}